library(dplyr)
library(broom)
library(tidyverse)
library(patchwork)
library(knitr)


#####################################################################
######### VISUALIZE PCs with BIPLOTS ################################
#####################################################################

arrow_style <- arrow(
  angle = 20, length = grid::unit(8, "pt"),
  ends = "first", type = "closed"
)


timss_tidy <- aligned$pca |>
  broom::tidy(matrix = "rotation") |>
  tidyr::pivot_wider(
    names_from = "PC", values_from = "value",
    names_prefix = "PC"
  )


# Create a new column for custom labels with multiple conditions
timss_tidy$custom_label <- dplyr::case_when(
  # Demographic / orienting
  timss_tidy$column == "female"               ~ "female",
  timss_tidy$column == "immigrant_student"    ~ "born outside the country",
  timss_tidy$column == "immigrant_pA"         ~ "immigrant parent",
  timss_tidy$column == "immigrant_pB"         ~ "immigrant parent",
  timss_tidy$column == "education_pA"         ~ "parent education",
  timss_tidy$column == "education_pB"         ~ "parent education",
  timss_tidy$column == "same_home_language"   ~ "same home and instruction language",
  timss_tidy$column == "home_resources"       ~ "home resources",
  
  # General affective / scales
  timss_tidy$column == "science_confidence"        ~ "science confidence",
  timss_tidy$column == "value_of_science"          ~ "student's value of science",
  timss_tidy$column == "expected_attainment"       ~ "student expected educational attainment",
  timss_tidy$column == "science_learning_attitude" ~ "positive attitude toward science",
  timss_tidy$column == "belonging"                 ~ "sense of school belonging",
  
  # Material classroom environment
  # timss_tidy$column == "dont_listen"        ~ "students don't listen",
  # timss_tidy$column == "noisy_class"        ~ "class is noisy",
  # timss_tidy$column == "wait_for_quiet"     ~ "teacher waits for quiet",
  # timss_tidy$column == "students_interrupt" ~ "students interrupt",
  # timss_tidy$column == "ignore_rules"       ~ "students ignore rules",
  # timss_tidy$column == "hard_concentrate"   ~ "hard to concentrate",
  # timss_tidy$column == "homework_quantity"  ~ "amount of science homework",
  
  # Enjoyment / interest / self-concept (BSBS25/28)
  timss_tidy$column == "enjoy_science"            ~ "science enjoyment",
  timss_tidy$column == "wish_no_science"          ~ "wish to avoid science",
  timss_tidy$column == "science_boring"           ~ "science is boring",
  timss_tidy$column == "science_interesting"      ~ "science is interesting",
  timss_tidy$column == "like_science"             ~ "I like science",
  timss_tidy$column == "look_forward_science"     ~ "look forward to science",
  timss_tidy$column == "science_favorite"         ~ "science favorite subject",
  timss_tidy$column == "do_well_science"          ~ "I do well in science",
  timss_tidy$column == "science_more_difficult"   ~ "greater science difficulty than peers",
  timss_tidy$column == "science_not_strength"     ~ "science is not my strength",
  timss_tidy$column == "quick_learn_science"      ~ "I learn science quickly",
  timss_tidy$column == "good_difficult_problems"  ~ "I am good at difficult problems",
  timss_tidy$column == "science_is_confusing"     ~ "science makes me confused",
  timss_tidy$column == "science_hardest_subject"  ~ "science more difficult than other subjects",
  timss_tidy$column == "i_explain_well"           ~ "I explain my science ideas well",
  
  # Teaching & classroom practices (BSBS24/26)
  timss_tidy$column == "experiments_frequency" ~ "frequency of science experiments",
  timss_tidy$column == "science_world_works"   ~ "science explains how the world works",
  timss_tidy$column == "like_experiments"      ~ "like experiments",
  timss_tidy$column == "teachers_care"         ~ "teachers care about me",
  timss_tidy$column == "clear_expectations"    ~ "clear classroom expectations",
  timss_tidy$column == "understand_teacher"    ~ "teacher easy to understand",
  timss_tidy$column == "clear_answers"         ~ "teacher gives clear answers",
  timss_tidy$column == "good_at_explaining"    ~ "teacher is good at explaining",
  timss_tidy$column == "variety_to_learn"      ~ "variety of teaching strategies",
  timss_tidy$column == "explains_again"        ~ "teacher explains multiple times",
  timss_tidy$column == "helpful_feedback"      ~ "helpful feedback",
  timss_tidy$column == "show_learning"         ~ "show what I learned",
  timss_tidy$column == "explain_answers"       ~ "teacher explains answers",
  timss_tidy$column == "apply_situations"      ~ "apply science to situations",
  
  # Value of science (BSBS29)
  timss_tidy$column == "helps_daily_life"          ~ "science helpful in daily life",
  timss_tidy$column == "helps_learn_other_subjects"~ "science necessary for other subjects",
  timss_tidy$column == "helps_college"             ~ "science necessary for college admission",
  timss_tidy$column == "helps_career"              ~ "science necessary for desired careers",
  timss_tidy$column == "want_job_with_science"     ~ "I want a job that involves science",
  timss_tidy$column == "helps_get_ahead"           ~ "science important for getting ahead",
  timss_tidy$column == "creates_more_opportunity"  ~ "learning science creates future opportunity",
  timss_tidy$column == "important_to_parents"      ~ "important to parents",
  timss_tidy$column == "important_to_me"           ~ "important to do well in science",
  
  TRUE ~ ""
)



# temporary labels to facilitate initial analysis of plots
#timss_tidy$custom_label <- match(timss_tidy$column, unique(timss_tidy$column))


# Vectors for variable groupings

orienting_factors <- c(
  "immigrant_student",
  "science_confidence",
  "value_of_science"
)

demographic <- c(
  "female", "education_pA", "education_pB",
  "immigrant_pA", "immigrant_pB",
  "same_home_language", "home_resources"
)

# material_classroom <- c(
#   "dont_listen", "noisy_class", "wait_for_quiet",
#   "students_interrupt", "ignore_rules",
#   "hard_concentrate", "homework_quantity"
# )

general_affective <- c(
  "belonging", "expected_attainment",
  "look_forward_science", "science_favorite",
  "do_well_science", "science_more_difficult", "science_not_strength",
  "enjoy_science", "wish_no_science", "science_boring", "science_interesting",
  "like_science", "quick_learn_science", "good_difficult_problems",
  "science_hardest_subject", "science_is_confusing",
  "important_to_parents", "important_to_me",
  "science_learning_attitude"
)

specific_affective <- c(
  "teachers_care", "experiments_frequency", "science_world_works",
  "like_experiments",
  "clear_expectations", "understand_teacher", "clear_answers",
  "good_at_explaining", "variety_to_learn", "explains_again",
  "helpful_feedback", "show_learning", "explain_answers", "apply_situations",
  "i_explain_well",
  "helps_daily_life", "helps_learn_other_subjects", "helps_college",
  "helps_career", "want_job_with_science", "helps_get_ahead",
  "creates_more_opportunity"
)


#reality_check <- c("enjoy_science", "wish_no_science", "science_boring", "science_interesting", "like_science",
#                   "do_well_science", "science_more_difficult", "science_not_strength")

###############################################################################
#################################### PLOTS ####################################
###############################################################################

n_1118 <- timss_tidy |>
  
  ggplot(aes(x = PC11, y = PC18)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.35) + ylim(-0, 0.33) +
  coord_fixed() +
  labs(title = "2023 TIMSS Italy 8th Grade Data Biplot of Principal Components")

n_1118

n_4043 <- timss_tidy |>
  
  ggplot(aes(x = PC40, y = PC43)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.41) + ylim(-0, 0.41) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

n_4043

n_1843 <- timss_tidy |>
  
  ggplot(aes(x = PC18, y = PC43)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.35) + ylim(-0, 0.41) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

n_1843


###############################################################################
############################# UNUSED PLOTS ####################################
###############################################################################

p_4346 <- timss_tidy |>
  
  ggplot(aes(x = PC43, y = PC46)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.6) + ylim(-0, 0.25) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_4346


p_4046 <- timss_tidy |>
  
  ggplot(aes(x = PC40, y = PC46)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.5) + ylim(-0, 0.22) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_4046

n_4043 <- timss_tidy |>
  
  ggplot(aes(x = PC40, y = PC43)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.41) + ylim(-0, 0.41) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

n_4043

p_1846 <- timss_tidy |>
  
  ggplot(aes(x = PC18, y = PC46)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.35) + ylim(-0, 0.25) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1846

n_1843 <- timss_tidy |>
  
  ggplot(aes(x = PC18, y = PC43)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.35) + ylim(-0, 0.41) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

n_1843

p_1840 <- timss_tidy |>
  
  ggplot(aes(x = PC18, y = PC40)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.3) + ylim(-0, 0.3) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1840

p_1746 <- timss_tidy |>
  
  ggplot(aes(x = PC17, y = PC46)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.7) + ylim(-0, 0.7) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1746


p_1743 <- timss_tidy |>
  
  ggplot(aes(x = PC17, y = PC43)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.7) + ylim(-0, 0.7) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1743


p_1740 <- timss_tidy |>
  
  ggplot(aes(x = PC17, y = PC40)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.7) + ylim(-0, 0.7) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1740

p_1718 <- timss_tidy |>
  
  ggplot(aes(x = PC17, y = PC18)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.42) + ylim(-0, 0.2) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1718

p_1446 <- timss_tidy |>
  
  ggplot(aes(x = PC14, y = PC46)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.7) + ylim(-0, 0.7) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1446

p_1443 <- timss_tidy |>
  
  ggplot(aes(x = PC14, y = PC43)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.7) + ylim(-0, 0.7) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1443

p_1440 <- timss_tidy |>
  
  ggplot(aes(x = PC14, y = PC40)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.4) + ylim(-0, 0.3) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1440

p_1418 <- timss_tidy |>
  
  ggplot(aes(x = PC14, y = PC18)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.4) + ylim(-0, 0.18) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1418

p_1417 <- timss_tidy |>
  
  ggplot(aes(x = PC14, y = PC17)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.4) + ylim(-0, 0.22) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1417

p_1146 <- timss_tidy |>
  
  ggplot(aes(x = PC11, y = PC46)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.75) + ylim(-0, 0.22) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1146

p_1143 <- timss_tidy |>
  
  ggplot(aes(x = PC11, y = PC43)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.31) + ylim(-0, 0.41) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1143

p_1140 <- timss_tidy |>
  
  ggplot(aes(x = PC11, y = PC40)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.25) + ylim(-0, 0.4) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1140

n_1118 <- timss_tidy |>
  
  ggplot(aes(x = PC11, y = PC18)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.35) + ylim(-0, 0.33) +
  coord_fixed() +
  labs(title = "2023 TIMSS Italy 8th Grade Data Biplot of Principal Components")

n_1118

p_1117 <- timss_tidy |>
  
  ggplot(aes(x = PC11, y = PC17)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.8) + ylim(-0, 0.2) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1117

p_1114 <- timss_tidy |>
  
  ggplot(aes(x = PC11, y = PC14)) +
  geom_segment(
    aes(xend = 0, yend = 0, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~  "#CC97A7",
          column %in% specific_affective ~ "#D55E00",
          #column %in% material_classroom    ~ "#800080",
          TRUE ~ "#009E73"
        ),
        alpha = case_when(
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ 0.5,
          column %in% demographic ~ 0.5,
          TRUE ~ 0.0
        )),
    arrow = arrow_style
  ) +
  geom_text(
    aes(label = custom_label, 
        color = case_when(
          column %in% orienting_factors ~ "#000000",
          column %in% general_affective ~ "#0072B2",
          column %in% demographic ~ "#CC79A7",
          column %in% specific_affective ~ "#D55E00",
          TRUE ~ "#CC79A7"
        ),
        alpha = case_when(
          
          column %in% orienting_factors ~ 1,
          column %in% general_affective ~ 0.5,
          column %in% specific_affective ~ .5,
          column %in% demographic ~ .7,
          TRUE ~ 0.30
        )), 
    hjust = -.01,
    vjust = 0.02,
    size = 5
  ) +
  scale_color_identity() + 
  scale_alpha_identity() +
  xlim(-0, 0.72) + ylim(-0, 0.3) +
  coord_fixed() +
  labs(title = "Detail of Biplot of Principal Components")

p_1114


